function [x, y] = Fixed_Scatter(p1, p2,Drift)

% This function generates a number of projected positions on a line between 
% two points p1, p2. The distance between each two projected positions is
% constant and determined by distance (Drift) between two points p1, p2.
% This function is mainly used for caculation of the vibrational noise
% value.

theta = atan2( p2(2) - p1(2), p2(1) - p1(1));
r = sqrt( (p2(1) - p1(1))^2 + (p2(2) - p1(2))^2);
line = 0:Drift:r;
x = p1(1) + line*cos(theta);
y = p1(2) + line*sin(theta);
scatter(x, y)

